<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once MODPATH.'core/controllers/nova_manage.php';

class Manage extends Nova_manage {

	public function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * Put your own methods below this...
	 */

public function saved()
{
		// load the resources
		$this->load->model('posts_model', 'post');
		$this->load->model('missions_model', 'mis');
		$this->load->library('pagination');
		
		// define the variables
		$data = false;
		$mission = false;
		$mission = $this->uri->segment(4, false, true);
		
		// get the title
		$title = ('Saved Mission Posts');

		{
			$offset = $this->uri->segment(3, 0, true);
		
			// set the pagination configs
			$config['base_url'] = site_url('manage/saved');
			$config['total_rows'] = $this->posts->count_all_posts();
			$config['per_page'] = $this->options['list_posts_num'];
			$config['full_tag_open'] = '<p class="fontMedium bold">';
			$config['full_tag_close'] = '</p>';
		
			// initialize the pagination library
			$this->pagination->initialize($config);
			
			// create the page links
			$data['pagination'] = $this->pagination->create_links();
			
			// run the method
			$posts = $this->posts->get_post_list('', 'desc', $config['per_page'], $offset, 'saved');
		}
		
		if ($posts->num_rows() > 0)
		{
			$datestring = $this->options['date_format'];
			
			foreach ($posts->result() as $post)
			{
				$date = gmt_to_local($post->post_date, $this->timezone, $this->dst);
				
				$data['posts'][$post->post_id]['id'] = $post->post_id;
				$data['posts'][$post->post_id]['title'] = $post->post_title;
				$data['posts'][$post->post_id]['author'] = $this->char->get_authors($post->post_authors, true, true);
				$data['posts'][$post->post_id]['date'] = mdate($datestring, $date);
				$data['posts'][$post->post_id]['mission'] = $this->mis->get_mission($post->post_mission, 'mission_title');
				$data['posts'][$post->post_id]['mission_id'] = $post->post_mission;
			}
			
			{
				$this->_regions['title'].= $title;
				$data['header'] = $title;
			}
		}
		
		if ($config['total_rows'] < $this->options['list_posts_num'])
		{
			$data['display'] = sprintf(
				lang('text_display_x_of_y'),
				$config['total_rows'],
				$config['total_rows'],
				lang('global_missionposts')
			);
		}
		else
		{
			$data['display'] = sprintf(
				lang('text_display_x_of_y'),
				$this->options['list_posts_num'],
				$config['total_rows'],
				lang('global_missionposts')
			);
		}
		
		$data['label'] = array(
			'by' => lang('labels_by'),
			'date' => ucfirst(lang('labels_date')),
			'mission' => ucfirst(lang('global_mission')) .':',
			'noposts' => sprintf(lang('error_not_found'), lang('global_missionposts')),
			'title' => ucfirst(lang('labels_title')),
		);
		
	$this->_regions['content'] = Location::view('saved', $this->skin, 'admin', $data);
	$this->_regions['javascript'] = Location::js('sim_listposts_js', $this->skin, 'main');

	Template::assign($this->_regions);
	
	Template::render();
}

}
