<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Install Genre - DS9
 *
 * @package		Nova
 * @category	Genre
 * @author		Anodyne Productions
 */

$g = 'ds9';

$data = array(
	'departments_'. $g 	=> 'depts',
	'ranks_'. $g		=> 'ranks',
	'positions_'. $g	=> 'positions',
	'catalogue_ranks'	=> 'catalogue_ranks',
);

$depts = array(
	array(
		'dept_name' => 'Command',
		'dept_desc' => "The Command department is ultimately responsible for the ship and its crew, and those within the department are responsible for commanding the vessel and representing the interests of Starfleet.",
		'dept_order' => 0,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Flight Control',
		'dept_desc' => "Responsible for the navigation and flight control of a vessel and its auxiliary craft, the Flight Control department includes pilots trained in both starship and auxiliary craft piloting. Note that the Flight Control department does not include Fighter pilots.",
		'dept_order' => 1,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Strategic Operations',
		'dept_desc' => "The Strategic Operations department acts as an advisory to the command staff, as well as a resource of knowledge and information concerning hostile races in the operational zone of the ship, as well as combat strategies and other such things.",
		'dept_order' => 2,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Security &amp; Tactical',
		'dept_desc' => "Merging the responsibilities of ship-to-ship and personnel combat into a single department, the security & tactical department is responsible for the tactical readiness of the vessel and the security of the ship.",
		'dept_order' => 3,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Operations',
		'dept_desc' => "The operations department is responsible for keeping ship systems functioning properly, rerouting power, bypassing relays, and doing whatever else is necessary to keep the ship operating at peak efficiency.",
		'dept_order' => 4,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Engineering',
		'dept_desc' => "The engineering department has the enormous task of keeping the ship working; they are responsible for making repairs, fixing problems, and making sure that the ship is ready for anything.",
		'dept_order' => 5,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Science',
		'dept_desc' => "From sensor readings to figuring out a way to enter the strange spacial anomaly, the science department is responsible for recording data, testing new ideas out, and making discoveries.",
		'dept_order' => 6,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Medical &amp; Counseling',
		'dept_desc' => "The medical & counseling department is responsible for the mental and physical health of the crew, from running annual physicals to combatting a strange plague that is afflicting the crew to helping a crew member deal with the loss of a loved one.",
		'dept_order' => 7,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Intelligence',
		'dept_desc' => "The Intelligence department is responsible for gathering and providing intelligence as it becomes possible during a mission; during covert missions, the intelligence department also takes a more active role, providing the necessary classified and other information.",
		'dept_order' => 8,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Diplomatic Detachment',
		'dept_desc' => "Responsible for representing the Federation and its interest, members of the Diplomatic Corps are members of the civilian branch of the Federation.",
		'dept_order' => 9,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Marine Detachment',
		'dept_desc' => "When the standard security detail is not enough, marines come in and clean up; the marine detachment is a powerful tactical addition to any ship, responsible for partaking in personal combat, from sniping to melee.",
		'dept_order' => 10,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Starfighter Wing',
		'dept_desc' => "The best pilots in Starfleet, they are responsible for piloting the starfighters in ship-to-ship battles, as well as providing escort for shuttles, and runabouts.",
		'dept_order' => 11,
		'dept_manifest' => 1),
	array(
		'dept_name' => 'Civilian Affairs',
		'dept_desc' => "Civilians play an important role in Starfleet. Many civilian specialists across a number of fields work on occasion with Starfleet personnel as a Mission Specialist. In other cases, extra ship and station duties, such as running the ship's lounge, are outsourced to a civilian contract.",
		'dept_order' => 12,
		'dept_manifest' => 1)
);

$ranks = array(
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 'r-a5',
		'rank_order' => 0,
		'rank_class' => 1),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 'y-a5',
		'rank_order' => 0,
		'rank_class' => 2),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 't-a5',
		'rank_order' => 0,
		'rank_class' => 3),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 's-a5',
		'rank_order' => 0,
		'rank_class' => 4),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 'v-a5',
		'rank_order' => 0,
		'rank_class' => 5),
	array(
		'rank_name' => 'Field Marshal',
		'rank_short_name' => 'FMSL',
		'rank_image' => 'g-a5',
		'rank_order' => 0,
		'rank_class' => 6),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 'c-a5',
		'rank_order' => 0,
		'rank_class' => 7),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 'b-a5',
		'rank_order' => 0,
		'rank_class' => 8),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 'd-a5',
		'rank_order' => 0,
		'rank_class' => 9),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 'o-a5',
		'rank_order' => 0,
		'rank_class' => 10),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 'p-a5',
		'rank_order' => 0,
		'rank_class' => 11),
	array(
		'rank_name' => 'Fleet Admiral',
		'rank_short_name' => 'FADM',
		'rank_image' => 'w-a5',
		'rank_order' => 0,
		'rank_class' => 12),
	
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 'r-a4',
		'rank_order' => 1,
		'rank_class' => 1),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 'y-a4',
		'rank_order' => 1,
		'rank_class' => 2),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 't-a4',
		'rank_order' => 1,
		'rank_class' => 3),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 's-a4',
		'rank_order' => 1,
		'rank_class' => 4),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 'v-a4',
		'rank_order' => 1,
		'rank_class' => 5),
	array(
		'rank_name' => 'General',
		'rank_short_name' => 'GEN',
		'rank_image' => 'g-a4',
		'rank_order' => 1,
		'rank_class' => 6),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 'c-a4',
		'rank_order' => 1,
		'rank_class' => 7),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 'b-a4',
		'rank_order' => 1,
		'rank_class' => 8),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 'd-a4',
		'rank_order' => 1,
		'rank_class' => 9),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 'o-a4',
		'rank_order' => 1,
		'rank_class' => 10),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 'p-a4',
		'rank_order' => 1,
		'rank_class' => 11),
	array(
		'rank_name' => 'Admiral',
		'rank_short_name' => 'ADM',
		'rank_image' => 'w-a4',
		'rank_order' => 1,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 'r-a3',
		'rank_order' => 2,
		'rank_class' => 1),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 'y-a3',
		'rank_order' => 2,
		'rank_class' => 2),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 't-a3',
		'rank_order' => 2,
		'rank_class' => 3),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 's-a3',
		'rank_order' => 2,
		'rank_class' => 4),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 'v-a3',
		'rank_order' => 2,
		'rank_class' => 5),
	array(
		'rank_name' => 'Lieutenant General',
		'rank_short_name' => 'LTGEN',
		'rank_image' => 'g-a3',
		'rank_order' => 2,
		'rank_class' => 6),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 'c-a3',
		'rank_order' => 2,
		'rank_class' => 7),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 'b-a3',
		'rank_order' => 2,
		'rank_class' => 8),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 'd-a3',
		'rank_order' => 2,
		'rank_class' => 9),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 'o-a3',
		'rank_order' => 2,
		'rank_class' => 10),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 'p-a3',
		'rank_order' => 2,
		'rank_class' => 11),
	array(
		'rank_name' => 'Vice Admiral',
		'rank_short_name' => 'VADM',
		'rank_image' => 'w-a3',
		'rank_order' => 2,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 'r-a2',
		'rank_order' => 3,
		'rank_class' => 1),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 'y-a2',
		'rank_order' => 3,
		'rank_class' => 2),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 't-a2',
		'rank_order' => 3,
		'rank_class' => 3),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 's-a2',
		'rank_order' => 3,
		'rank_class' => 4),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 'v-a2',
		'rank_order' => 3,
		'rank_class' => 5),
	array(
		'rank_name' => 'Major General',
		'rank_short_name' => 'MAJGEN',
		'rank_image' => 'g-a2',
		'rank_order' => 3,
		'rank_class' => 6),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 'c-a2',
		'rank_order' => 3,
		'rank_class' => 7),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 'b-a2',
		'rank_order' => 3,
		'rank_class' => 8),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 'd-a2',
		'rank_order' => 3,
		'rank_class' => 9),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 'o-a2',
		'rank_order' => 3,
		'rank_class' => 10),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 'p-a2',
		'rank_order' => 3,
		'rank_class' => 11),
	array(
		'rank_name' => 'Rear Admiral',
		'rank_short_name' => 'RADM',
		'rank_image' => 'w-a2',
		'rank_order' => 3,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 'r-a1',
		'rank_order' => 4,
		'rank_class' => 1),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 'y-a1',
		'rank_order' => 4,
		'rank_class' => 2),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 't-a1',
		'rank_order' => 4,
		'rank_class' => 3),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 's-a1',
		'rank_order' => 4,
		'rank_class' => 4),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 'v-a1',
		'rank_order' => 4,
		'rank_class' => 5),
	array(
		'rank_name' => 'Brigadier General',
		'rank_short_name' => 'BGEN',
		'rank_image' => 'g-a1',
		'rank_order' => 4,
		'rank_class' => 6),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 'c-a1',
		'rank_order' => 4,
		'rank_class' => 7),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 'b-a1',
		'rank_order' => 4,
		'rank_class' => 8),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 'd-a1',
		'rank_order' => 4,
		'rank_class' => 9),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 'o-a1',
		'rank_order' => 4,
		'rank_class' => 10),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 'p-a1',
		'rank_order' => 4,
		'rank_class' => 11),
	array(
		'rank_name' => 'Commodore',
		'rank_short_name' => 'COM',
		'rank_image' => 'w-a1',
		'rank_order' => 4,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'r-o6',
		'rank_order' => 5,
		'rank_class' => 1),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'y-o6',
		'rank_order' => 5,
		'rank_class' => 2),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 't-o6',
		'rank_order' => 5,
		'rank_class' => 3),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 's-o6',
		'rank_order' => 5,
		'rank_class' => 4),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'v-o6',
		'rank_order' => 5,
		'rank_class' => 5),
	array(
		'rank_name' => 'Colonel',
		'rank_short_name' => 'COL',
		'rank_image' => 'g-o6',
		'rank_order' => 5,
		'rank_class' => 6),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'c-o6',
		'rank_order' => 5,
		'rank_class' => 7),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'b-o6',
		'rank_order' => 5,
		'rank_class' => 8),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'd-o6',
		'rank_order' => 5,
		'rank_class' => 9),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'o-o6',
		'rank_order' => 5,
		'rank_class' => 10),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'p-o6',
		'rank_order' => 5,
		'rank_class' => 11),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'w-o6',
		'rank_order' => 5,
		'rank_class' => 12),
	
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 'r-o5',
		'rank_order' => 6,
		'rank_class' => 1),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 'y-o5',
		'rank_order' => 6,
		'rank_class' => 2),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 't-o5',
		'rank_order' => 6,
		'rank_class' => 3),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 's-o5',
		'rank_order' => 6,
		'rank_class' => 4),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 'v-o5',
		'rank_order' => 6,
		'rank_class' => 5),
	array(
		'rank_name' => 'Lieutenant Colonel',
		'rank_short_name' => 'LTCOL',
		'rank_image' => 'g-o5',
		'rank_order' => 6,
		'rank_class' => 6),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 'c-o5',
		'rank_order' => 6,
		'rank_class' => 7),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 'b-o5',
		'rank_order' => 6,
		'rank_class' => 8),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 'd-o5',
		'rank_order' => 6,
		'rank_class' => 9),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 'o-o5',
		'rank_order' => 6,
		'rank_class' => 10),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 'p-o5',
		'rank_order' => 6,
		'rank_class' => 11),
	array(
		'rank_name' => 'Commander',
		'rank_short_name' => 'CMDR',
		'rank_image' => 'w-o5',
		'rank_order' => 6,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 'r-o4',
		'rank_order' => 7,
		'rank_class' => 1),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 'y-o4',
		'rank_order' => 7,
		'rank_class' => 2),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 't-o4',
		'rank_order' => 7,
		'rank_class' => 3),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 's-o4',
		'rank_order' => 7,
		'rank_class' => 4),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 'v-o4',
		'rank_order' => 7,
		'rank_class' => 5),
	array(
		'rank_name' => 'Major',
		'rank_short_name' => 'MAJ',
		'rank_image' => 'g-o4',
		'rank_order' => 7,
		'rank_class' => 6),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 'c-o4',
		'rank_order' => 7,
		'rank_class' => 7),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 'b-o4',
		'rank_order' => 7,
		'rank_class' => 8),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 'd-o4',
		'rank_order' => 7,
		'rank_class' => 9),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 'o-o4',
		'rank_order' => 7,
		'rank_class' => 10),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 'p-o4',
		'rank_order' => 7,
		'rank_class' => 11),
	array(
		'rank_name' => 'Lieutenant Commander',
		'rank_short_name' => 'LTCMDR',
		'rank_image' => 'w-o4',
		'rank_order' => 7,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 'r-o3',
		'rank_order' => 8,
		'rank_class' => 1),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 'y-o3',
		'rank_order' => 8,
		'rank_class' => 2),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 't-o3',
		'rank_order' => 8,
		'rank_class' => 3),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 's-o3',
		'rank_order' => 8,
		'rank_class' => 4),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 'v-o3',
		'rank_order' => 8,
		'rank_class' => 5),
	array(
		'rank_name' => 'Captain',
		'rank_short_name' => 'CAPT',
		'rank_image' => 'g-o3',
		'rank_order' => 8,
		'rank_class' => 6),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 'c-o3',
		'rank_order' => 8,
		'rank_class' => 7),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 'b-o3',
		'rank_order' => 8,
		'rank_class' => 8),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 'd-o3',
		'rank_order' => 8,
		'rank_class' => 9),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 'o-o3',
		'rank_order' => 8,
		'rank_class' => 10),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 'p-o3',
		'rank_order' => 8,
		'rank_class' => 11),
	array(
		'rank_name' => 'Lieutenant',
		'rank_short_name' => 'LT',
		'rank_image' => 'w-o3',
		'rank_order' => 8,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 'r-o2',
		'rank_order' => 9,
		'rank_class' => 1),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 'y-o2',
		'rank_order' => 9,
		'rank_class' => 2),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 't-o2',
		'rank_order' => 9,
		'rank_class' => 3),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 's-o2',
		'rank_order' => 9,
		'rank_class' => 4),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 'v-o2',
		'rank_order' => 9,
		'rank_class' => 5),
	array(
		'rank_name' => '1st Lieutenant',
		'rank_short_name' => '1LT',
		'rank_image' => 'g-o2',
		'rank_order' => 9,
		'rank_class' => 6),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 'c-o2',
		'rank_order' => 9,
		'rank_class' => 7),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 'b-o2',
		'rank_order' => 9,
		'rank_class' => 8),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 'd-o2',
		'rank_order' => 9,
		'rank_class' => 9),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 'o-o2',
		'rank_order' => 9,
		'rank_class' => 10),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 'p-o2',
		'rank_order' => 9,
		'rank_class' => 11),
	array(
		'rank_name' => 'Lieutenant JG',
		'rank_short_name' => 'LT(JG)',
		'rank_image' => 'w-o2',
		'rank_order' => 9,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 'r-o1',
		'rank_order' => 10,
		'rank_class' => 1),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 'y-o1',
		'rank_order' => 10,
		'rank_class' => 2),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 't-o1',
		'rank_order' => 10,
		'rank_class' => 3),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 's-o1',
		'rank_order' => 10,
		'rank_class' => 4),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 'v-o1',
		'rank_order' => 10,
		'rank_class' => 5),
	array(
		'rank_name' => '2nd Lieutenant',
		'rank_short_name' => '2LT',
		'rank_image' => 'g-o1',
		'rank_order' => 10,
		'rank_class' => 6),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 'c-o1',
		'rank_order' => 10,
		'rank_class' => 7),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 'b-o1',
		'rank_order' => 10,
		'rank_class' => 8),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 'd-o1',
		'rank_order' => 10,
		'rank_class' => 9),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 'o-o1',
		'rank_order' => 10,
		'rank_class' => 10),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 'p-o1',
		'rank_order' => 10,
		'rank_class' => 11),
	array(
		'rank_name' => 'Ensign',
		'rank_short_name' => 'ENS',
		'rank_image' => 'w-o1',
		'rank_order' => 10,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'r-w4',
		'rank_order' => 11,
		'rank_class' => 1),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'y-w4',
		'rank_order' => 11,
		'rank_class' => 2),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 't-w4',
		'rank_order' => 11,
		'rank_class' => 3),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 's-w4',
		'rank_order' => 11,
		'rank_class' => 4),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'v-w4',
		'rank_order' => 11,
		'rank_class' => 5),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'g-w4',
		'rank_order' => 11,
		'rank_class' => 6),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'c-w4',
		'rank_order' => 11,
		'rank_class' => 7),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'b-w4',
		'rank_order' => 11,
		'rank_class' => 8),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'd-w4',
		'rank_order' => 11,
		'rank_class' => 9),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'o-w4',
		'rank_order' => 11,
		'rank_class' => 10),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'p-w4',
		'rank_order' => 11,
		'rank_class' => 11),
	array(
		'rank_name' => 'Chief Warrant Officer',
		'rank_short_name' => 'CWO',
		'rank_image' => 'w-w4',
		'rank_order' => 11,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'r-w3',
		'rank_order' => 12,
		'rank_class' => 1),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'y-w3',
		'rank_order' => 12,
		'rank_class' => 2),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 't-w3',
		'rank_order' => 12,
		'rank_class' => 3),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 's-w3',
		'rank_order' => 12,
		'rank_class' => 4),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'v-w3',
		'rank_order' => 12,
		'rank_class' => 5),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'g-w3',
		'rank_order' => 12,
		'rank_class' => 6),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'c-w3',
		'rank_order' => 12,
		'rank_class' => 7),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'b-w3',
		'rank_order' => 12,
		'rank_class' => 8),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'd-w3',
		'rank_order' => 12,
		'rank_class' => 9),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'o-w3',
		'rank_order' => 12,
		'rank_class' => 10),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'p-w3',
		'rank_order' => 12,
		'rank_class' => 11),
	array(
		'rank_name' => 'Master Warrant Officer',
		'rank_short_name' => 'MWO',
		'rank_image' => 'w-w3',
		'rank_order' => 12,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'r-w2',
		'rank_order' => 13,
		'rank_class' => 1),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'y-w2',
		'rank_order' => 13,
		'rank_class' => 2),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 't-w2',
		'rank_order' => 13,
		'rank_class' => 3),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 's-w2',
		'rank_order' => 13,
		'rank_class' => 4),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'v-w2',
		'rank_order' => 13,
		'rank_class' => 5),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'g-w2',
		'rank_order' => 13,
		'rank_class' => 6),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'c-w2',
		'rank_order' => 13,
		'rank_class' => 7),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'b-w2',
		'rank_order' => 13,
		'rank_class' => 8),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'd-w2',
		'rank_order' => 13,
		'rank_class' => 9),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'o-w2',
		'rank_order' => 13,
		'rank_class' => 10),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'p-w2',
		'rank_order' => 13,
		'rank_class' => 11),
	array(
		'rank_name' => 'Staff Warrant Officer',
		'rank_short_name' => 'SWO',
		'rank_image' => 'w-w2',
		'rank_order' => 13,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'r-w1',
		'rank_order' => 14,
		'rank_class' => 1),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'y-w1',
		'rank_order' => 14,
		'rank_class' => 2),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 't-w1',
		'rank_order' => 14,
		'rank_class' => 3),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 's-w1',
		'rank_order' => 14,
		'rank_class' => 4),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'v-w1',
		'rank_order' => 14,
		'rank_class' => 5),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'g-w1',
		'rank_order' => 14,
		'rank_class' => 6),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'c-w1',
		'rank_order' => 14,
		'rank_class' => 7),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'b-w1',
		'rank_order' => 14,
		'rank_class' => 8),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'd-w1',
		'rank_order' => 14,
		'rank_class' => 9),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'o-w1',
		'rank_order' => 14,
		'rank_class' => 10),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'p-w1',
		'rank_order' => 14,
		'rank_class' => 11),
	array(
		'rank_name' => 'Warrant Officer',
		'rank_short_name' => 'WO',
		'rank_image' => 'w-w1',
		'rank_order' => 14,
		'rank_class' => 12),
	
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 'r-e9',
		'rank_order' => 15,
		'rank_class' => 1),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 'y-e9',
		'rank_order' => 15,
		'rank_class' => 2),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 't-e9',
		'rank_order' => 15,
		'rank_class' => 3),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 's-e9',
		'rank_order' => 15,
		'rank_class' => 4),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 'v-e9',
		'rank_order' => 15,
		'rank_class' => 5),
	array(
		'rank_name' => 'Sergeant Major',
		'rank_short_name' => 'SGTMAJ',
		'rank_image' => 'g-e9',
		'rank_order' => 15,
		'rank_class' => 6),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 'c-e9',
		'rank_order' => 15,
		'rank_class' => 7),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 'b-e9',
		'rank_order' => 15,
		'rank_class' => 8),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 'd-e9',
		'rank_order' => 15,
		'rank_class' => 9),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 'o-e9',
		'rank_order' => 15,
		'rank_class' => 10),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 'p-e9',
		'rank_order' => 15,
		'rank_class' => 11),
	array(
		'rank_name' => 'Master Chief Petty Officer',
		'rank_short_name' => 'MCPO',
		'rank_image' => 'w-e9',
		'rank_order' => 15,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 'r-e8',
		'rank_order' => 16,
		'rank_class' => 1),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 'y-e8',
		'rank_order' => 16,
		'rank_class' => 2),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 't-e8',
		'rank_order' => 16,
		'rank_class' => 3),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 's-e8',
		'rank_order' => 16,
		'rank_class' => 4),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 'v-e8',
		'rank_order' => 16,
		'rank_class' => 5),
	array(
		'rank_name' => 'Master Sergeant',
		'rank_short_name' => 'MSGT',
		'rank_image' => 'g-e8',
		'rank_order' => 16,
		'rank_class' => 6),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 'c-e8',
		'rank_order' => 16,
		'rank_class' => 7),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 'b-e8',
		'rank_order' => 16,
		'rank_class' => 8),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 'd-e8',
		'rank_order' => 16,
		'rank_class' => 9),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 'o-e8',
		'rank_order' => 16,
		'rank_class' => 10),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 'p-e8',
		'rank_order' => 16,
		'rank_class' => 11),
	array(
		'rank_name' => 'Senior Chief Petty Officer',
		'rank_short_name' => 'SCPO',
		'rank_image' => 'w-e8',
		'rank_order' => 16,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 'r-e7',
		'rank_order' => 17,
		'rank_class' => 1),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 'y-e7',
		'rank_order' => 17,
		'rank_class' => 2),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 't-e7',
		'rank_order' => 17,
		'rank_class' => 3),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 's-e7',
		'rank_order' => 17,
		'rank_class' => 4),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 'v-e7',
		'rank_order' => 17,
		'rank_class' => 5),
	array(
		'rank_name' => 'Gunnery Sergeant',
		'rank_short_name' => 'GYSGT',
		'rank_image' => 'g-e7',
		'rank_order' => 17,
		'rank_class' => 6),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 'c-e7',
		'rank_order' => 17,
		'rank_class' => 7),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 'b-e7',
		'rank_order' => 17,
		'rank_class' => 8),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 'd-e7',
		'rank_order' => 17,
		'rank_class' => 9),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 'o-e7',
		'rank_order' => 17,
		'rank_class' => 10),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 'p-e7',
		'rank_order' => 17,
		'rank_class' => 11),
	array(
		'rank_name' => 'Chief Petty Officer',
		'rank_short_name' => 'CPO',
		'rank_image' => 'w-e7',
		'rank_order' => 17,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 'r-e6',
		'rank_order' => 18,
		'rank_class' => 1),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 'y-e6',
		'rank_order' => 18,
		'rank_class' => 2),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 't-e6',
		'rank_order' => 18,
		'rank_class' => 3),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 's-e6',
		'rank_order' => 18,
		'rank_class' => 4),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 'v-e6',
		'rank_order' => 18,
		'rank_class' => 5),
	array(
		'rank_name' => 'Staff Sergeant',
		'rank_short_name' => 'SSGT',
		'rank_image' => 'g-e6',
		'rank_order' => 18,
		'rank_class' => 6),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 'c-e6',
		'rank_order' => 18,
		'rank_class' => 7),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 'b-e6',
		'rank_order' => 18,
		'rank_class' => 8),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 'd-e6',
		'rank_order' => 18,
		'rank_class' => 9),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 'o-e6',
		'rank_order' => 18,
		'rank_class' => 10),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 'p-e6',
		'rank_order' => 18,
		'rank_class' => 11),
	array(
		'rank_name' => 'Petty Officer 1st Class',
		'rank_short_name' => 'PO1',
		'rank_image' => 'w-e6',
		'rank_order' => 18,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 'r-e5',
		'rank_order' => 19,
		'rank_class' => 1),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 'y-e5',
		'rank_order' => 19,
		'rank_class' => 2),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 't-e5',
		'rank_order' => 19,
		'rank_class' => 3),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 's-e5',
		'rank_order' => 19,
		'rank_class' => 4),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 'v-e5',
		'rank_order' => 19,
		'rank_class' => 5),
	array(
		'rank_name' => 'Sergeant',
		'rank_short_name' => 'SGT',
		'rank_image' => 'g-e5',
		'rank_order' => 19,
		'rank_class' => 6),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 'c-e5',
		'rank_order' => 19,
		'rank_class' => 7),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 'b-e5',
		'rank_order' => 19,
		'rank_class' => 8),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 'd-e5',
		'rank_order' => 19,
		'rank_class' => 9),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 'o-e5',
		'rank_order' => 19,
		'rank_class' => 10),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 'p-e5',
		'rank_order' => 19,
		'rank_class' => 11),
	array(
		'rank_name' => 'Petty Officer 2nd Class',
		'rank_short_name' => 'PO2',
		'rank_image' => 'w-e5',
		'rank_order' => 19,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 'r-e4',
		'rank_order' => 20,
		'rank_class' => 1),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 'y-e4',
		'rank_order' => 20,
		'rank_class' => 2),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 't-e4',
		'rank_order' => 20,
		'rank_class' => 3),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 's-e4',
		'rank_order' => 20,
		'rank_class' => 4),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 'v-e4',
		'rank_order' => 20,
		'rank_class' => 5),
	array(
		'rank_name' => 'Corporal',
		'rank_short_name' => 'CPL',
		'rank_image' => 'g-e4',
		'rank_order' => 20,
		'rank_class' => 6),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 'c-e4',
		'rank_order' => 20,
		'rank_class' => 7),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 'b-e4',
		'rank_order' => 20,
		'rank_class' => 8),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 'd-e4',
		'rank_order' => 20,
		'rank_class' => 9),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 'o-e4',
		'rank_order' => 20,
		'rank_class' => 10),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 'p-e4',
		'rank_order' => 20,
		'rank_class' => 11),
	array(
		'rank_name' => 'Petty Officer 3rd Class',
		'rank_short_name' => 'PO3',
		'rank_image' => 'w-e4',
		'rank_order' => 20,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 'r-e3',
		'rank_order' => 21,
		'rank_class' => 1),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 'y-e3',
		'rank_order' => 21,
		'rank_class' => 2),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 't-e3',
		'rank_order' => 21,
		'rank_class' => 3),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 's-e3',
		'rank_order' => 21,
		'rank_class' => 4),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 'v-e3',
		'rank_order' => 21,
		'rank_class' => 5),
	array(
		'rank_name' => 'Lance Corporal',
		'rank_short_name' => 'LCPL',
		'rank_image' => 'g-e3',
		'rank_order' => 21,
		'rank_class' => 6),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 'c-e3',
		'rank_order' => 21,
		'rank_class' => 7),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 'b-e3',
		'rank_order' => 21,
		'rank_class' => 8),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 'd-e3',
		'rank_order' => 21,
		'rank_class' => 9),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 'o-e3',
		'rank_order' => 21,
		'rank_class' => 10),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 'p-e3',
		'rank_order' => 21,
		'rank_class' => 11),
	array(
		'rank_name' => 'Crewman',
		'rank_short_name' => 'CN',
		'rank_image' => 'w-e3',
		'rank_order' => 21,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 'r-e2',
		'rank_order' => 22,
		'rank_class' => 1),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 'y-e2',
		'rank_order' => 22,
		'rank_class' => 2),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 't-e2',
		'rank_order' => 22,
		'rank_class' => 3),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 's-e2',
		'rank_order' => 22,
		'rank_class' => 4),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 'v-e2',
		'rank_order' => 22,
		'rank_class' => 5),
	array(
		'rank_name' => 'Private 1st Class',
		'rank_short_name' => 'PFC',
		'rank_image' => 'g-e2',
		'rank_order' => 22,
		'rank_class' => 6),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 'c-e2',
		'rank_order' => 22,
		'rank_class' => 7),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 'b-e2',
		'rank_order' => 22,
		'rank_class' => 8),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 'd-e2',
		'rank_order' => 22,
		'rank_class' => 9),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 'o-e2',
		'rank_order' => 22,
		'rank_class' => 10),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 'p-e2',
		'rank_order' => 22,
		'rank_class' => 11),
	array(
		'rank_name' => 'Crewman Apprentice',
		'rank_short_name' => 'CA',
		'rank_image' => 'w-e2',
		'rank_order' => 22,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 'r-e1',
		'rank_order' => 23,
		'rank_class' => 1),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 'y-e1',
		'rank_order' => 23,
		'rank_class' => 2),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 't-e1',
		'rank_order' => 23,
		'rank_class' => 3),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 's-e1',
		'rank_order' => 23,
		'rank_class' => 4),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 'v-e1',
		'rank_order' => 23,
		'rank_class' => 5),
	array(
		'rank_name' => 'Private',
		'rank_short_name' => 'PVT',
		'rank_image' => 'g-e1',
		'rank_order' => 23,
		'rank_class' => 6),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 'c-e1',
		'rank_order' => 23,
		'rank_class' => 7),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 'b-e1',
		'rank_order' => 23,
		'rank_class' => 8),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 'd-e1',
		'rank_order' => 23,
		'rank_class' => 9),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 'o-e1',
		'rank_order' => 23,
		'rank_class' => 10),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 'p-e1',
		'rank_order' => 23,
		'rank_class' => 11),
	array(
		'rank_name' => 'Crewman Recruit',
		'rank_short_name' => 'CR',
		'rank_image' => 'w-e1',
		'rank_order' => 23,
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'r-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 1),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'y-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 2),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 't-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 3),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 's-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 4),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'v-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 5),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'g-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 6),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'c-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 7),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'b-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 8),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'd-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 9),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'o-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 10),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'p-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 11),
	array(
		'rank_name' => 'Cadet Senior Grade',
		'rank_short_name' => 'CDT(SR)',
		'rank_image' => 'w-c4',
		'rank_order' => 24,
		'rank_display' => 'n',
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'r-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 1),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'y-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 2),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 't-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 3),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 's-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 4),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'v-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 5),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'g-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 6),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'c-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 7),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'b-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 8),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'd-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 9),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'o-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 10),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'p-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 11),
	array(
		'rank_name' => 'Cadet Junior Grade',
		'rank_short_name' => 'CDT(JR)',
		'rank_image' => 'w-c3',
		'rank_order' => 25,
		'rank_display' => 'n',
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'r-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 1),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'y-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 2),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 't-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 3),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 's-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 4),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'v-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 5),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'g-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 6),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'c-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 7),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'b-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 8),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'd-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 9),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'o-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 10),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'p-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 11),
	array(
		'rank_name' => 'Cadet Sophomore Grade',
		'rank_short_name' => 'CDT(SO)',
		'rank_image' => 'w-c2',
		'rank_order' => 26,
		'rank_display' => 'n',
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'r-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 1),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'y-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 2),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 't-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 3),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 's-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 4),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'v-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 5),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'g-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 6),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'c-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 7),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'b-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 8),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'd-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 9),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'o-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 10),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'p-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 11),
	array(
		'rank_name' => 'Cadet Freshman Grade',
		'rank_short_name' => 'CDT(FR)',
		'rank_image' => 'w-c1',
		'rank_order' => 27,
		'rank_display' => 'n',
		'rank_class' => 12),
		
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'r-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 1),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'y-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 2),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 't-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 3),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 's-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 4),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'v-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 5),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'g-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 6),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'c-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 7),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'b-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 8),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'd-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 9),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'o-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 10),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'p-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 11),
	array(
		'rank_name' => 'Enlisted Cadet',
		'rank_short_name' => 'CDT(EN)',
		'rank_image' => 'w-c0',
		'rank_order' => 28,
		'rank_display' => 'n',
		'rank_class' => 12),
		
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'r-blank',
		'rank_order' => 29,
		'rank_class' => 1),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'y-blank',
		'rank_order' => 29,
		'rank_class' => 2),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 't-blank',
		'rank_order' => 29,
		'rank_class' => 3),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 's-blank',
		'rank_order' => 29,
		'rank_class' => 4),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'v-blank',
		'rank_order' => 29,
		'rank_class' => 5),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'g-blank',
		'rank_order' => 29,
		'rank_class' => 6),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'c-blank',
		'rank_order' => 29,
		'rank_class' => 7),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'b-blank',
		'rank_order' => 29,
		'rank_class' => 8),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'd-blank',
		'rank_order' => 29,
		'rank_class' => 9),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'o-blank',
		'rank_order' => 29,
		'rank_class' => 10),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'p-blank',
		'rank_order' => 29,
		'rank_class' => 11),
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'w-blank',
		'rank_order' => 29,
		'rank_class' => 12),
		
	array(
		'rank_name' => '',
		'rank_short_name' => '',
		'rank_image' => 'blank',
		'rank_order' => 0,
		'rank_class' => 13),
);

$positions = array(
	array(
		'pos_name' => 'Commanding Officer',
		'pos_desc' => "Ultimately responsible for the ship and crew, the Commanding Officer is the most senior officer aboard a vessel. S/he is responsible for carrying out the orders of Starfleet, and for representing both Starfleet and the Federation.",
		'pos_dept' => 1,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Executive Officer',
		'pos_desc' => "The liaison between captain and crew, the Executive Officer acts as the disciplinarian, personnel manager, advisor to the captain, and much more. S/he is also one of only two officers, along with the Chief Medical Officer, that can remove a Commanding Officer from duty.",
		'pos_dept' => 1,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Second Officer',
		'pos_desc' => "At times the XO must assume command of a Starship or base, when this happens the XO needs the help of another officer to assume his/her role as XO. The second officer is not a stand alone position, but a role given to the highest ranked and trusted officer aboard. When required the Second Officer will assume the role of XO, or if needed CO, and performs their duties as listed, for as long as required.",
		'pos_dept' => 1,
		'pos_order' => 2,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Chief of the Boat',
		'pos_desc' => "The seniormost Chief Petty Officer (including Senior and Master Chiefs), regardless of rating, is designated by the Commanding Officer as the Chief of the Boat (for vessels) or Command Chief (for starbases). In addition to his or her departmental responsibilities, the COB/CC performs the following duties: serves as a liaison between the Commanding Officer (or Executive Officer) and the enlisted crewmen; ensures enlisted crews understand Command policies; advises the Commanding Officer and Executive Officer regarding enlisted morale, and evaluates the quality of noncommissioned officer leadership, management, and supervisory training.\r\n\r\nThe COB/CC works with the other department heads, Chiefs, supervisors, and crewmen to insure discipline is equitably maintained, and the welfare, morale, and health needs of the enlisted personnel are met. The COB/CC is qualified to temporarily act as Commanding or Executive Officer if so ordered.",
		'pos_dept' => 1,
		'pos_order' => 3,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Mission Advisor',
		'pos_desc' => "Advises the Commanding Officer and Executive Officer on mission-specific areas of importance. Many times, the Mission Advisor knows just as much about the mission as the CO and XO do, if not even more. He or she also performs mission-specific tasks, and can take on any roles that a mission requires him or her to do. Concurrently holds another position, except in rare circumstances.",
		'pos_dept' => 1,
		'pos_order' => 4,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Yeoman',
		'pos_desc' => "The Captain's Yeoman is for Petty Officers who wish to continue as administrators. It is technically a non-Mate position. Use of this position is completely at the discretion of the Commanding Officer. File work, and sensitive message transport are but two examples of the Yeoman's possible duties. The Yeoman assists the CO in day-to-day duties that the CO would otherwise not have the time to do.",
		'pos_dept' => 1,
		'pos_order' => 5,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	
	array(
		'pos_name' => 'Chief Flight Control Officer',
		'pos_desc' => "Originally known as helm, or Flight Control Officer, CONN incorporates two job, Navigation and flight control. A Flight Control Officer must always be present on the bridge of a starship. S/he plots courses, supervises the computers piloting, corrects any flight deviations and pilots the ship manually when needed. The Chief Flight Control Officer is the senior most CONN Officer aboard, serving as a Senior Officer, and chief of the personnel under him/her.",
		'pos_dept' => 2,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Assistant Chief Flight Control Officer',
		'pos_desc' => "Originally known as helm, or Flight Control Officer, CONN incorporates two job, Navigation and flight control. A Flight Control Officer must always be present on the bridge of a starship. S/he plots courses, supervises the computers piloting, corrects any flight deviations and pilots the ship manually when needed. The Assistant Chief Flight Control Officer is the second senior most CONN Officer aboard and reports directly to the Chief Flight Control Officer.",
		'pos_dept' => 2,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Flight Control Officer',
		'pos_desc' => "Originally know as helm, or Flight Control Officer, CONN incorporates two job, navigation and flight control. A Flight Control Officer must always be present on the bridge of a starship, and every vessel has a number of Flight Control Officers to allow shift rotations. S/he plots courses, supervises the computers piloting, corrects any flight deviations and pilots the ship manually when needed. Flight Control Officers report to the Chief Flight Control Officer.",
		'pos_dept' => 2,
		'pos_order' => 2,
		'pos_open' => 3,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Shuttlebay Manager',
		'pos_desc' => "The Shuttlebay Manager is responsible for pre and post flight checks of all support craft involved in away missions. Once a support craft has been brought to the flight line, it is his/her duty to ensure that it is mission capable. Upon returning from a mission, he/she must inspect the support craft and prepare a report on any maintenance that is required.\r\n\r\nHe/she is also responsible for the placement of support craft in order to allow for maximum efficiency of the shuttlebay.",
		'pos_dept' => 2,
		'pos_order' => 3,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Chief Support Craft Pilot',
		'pos_desc' => "All small spacecrafts aboard a starship, starbase or a facility (Shuttles, Runabouts, Transports, Captain's yacht, Patrol Vessels etc.) but excluding fighters are flown by Support Craft Pilots. This is often the proving ground for pilots until they earn a berth on a starship as a Flight Control Officer.\r\n\r\nThe Chief Support Craft Pilot reports to the Chief Flight Control Officer.",
		'pos_dept' => 2,
		'pos_order' => 4,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Support Craft Pilot',
		'pos_desc' => "All small spacecrafts aboard a starship, starbase or a facility (Shuttles, Runabouts, Transports, Captain's yacht, Patrol Vessels etc.) but excluding fighters are flown by Support Craft Pilots. This is often the proving ground for pilots until they earn a berth on a starship as a Flight Control Officer. They report to the Chief Support Craft Pilot.",
		'pos_dept' => 2,
		'pos_order' => 5,
		'pos_open' => 4,
		'pos_type' => 'officer'),
		
	array(
		'pos_name' => 'Chief Strategic Operations Officer',
		'pos_desc' => "The Chief Strategic Operations Officer is responsible for coordinating all Starfleet and allied assets in within their designated area of space, as well as tactical analysis (in the absence of a dedicated tactical department) and intelligence gathering (in the absence of a dedicated intelligence department).",
		'pos_dept' => 3,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Assistant Chief Strategic Operations Officer',
		'pos_desc' => "The Assistant Chief Strategic Operations Officer is the second ranked officer in the Strategic Operations department. He or she answers to the Chief Strategic Operations Officer. He or she is responsible for coordinating Starfleet and allied assets within a designated area of space, as well as tactical analysis and intelligence gathering.",
		'pos_dept' => 3,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Strategic Operations Officer',
		'pos_desc' => "The Strategic Operations Officer is part of the Strategic Operations department. He or she answers to the Chief Strategic Operations Officer. He or she is responsible for coordinating Starfleet and allied assets within a designated area of space, as well as tactical analysis and intelligence gathering.",
		'pos_dept' => 3,
		'pos_order' => 2,
		'pos_open' => 3,
		'pos_type' => 'officer'),
	
	array(
		'pos_name' => 'Chief Security/Tactical Officer',
		'pos_desc' => "The Chief Security Officer is called Chief of Security. Her/his duty is to ensure the safety of ship and crew. Some take it as their personal duty to protect the Commanding Officer/Executive Officer on away teams. She/he is also responsible for people under arrest and the safety of guests, liked or not.  S/he also is a department head and a member of the senior staff, responsible for all the crew members in her/his department and duty rosters. Security could be called the 24th century police force.\r\n\r\nThe Chief of Security role can also be combined with the Chief Tactical Officer position.",
		'pos_dept' => 4,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Assistant Chief Security/Tactical Officer',
		'pos_desc' => "The Assistant Chief Security Officer is sometimes called Deputy of Security. S/he assists the Chief of Security in the daily work; in issues regarding Security and any administrative matters.  If required the Deputy must be able to take command of the Security department.",
		'pos_dept' => 4,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Security Officer',
		'pos_desc' => "There are several Security Officers aboard each vessel. They are assigned to their duties by the Chief of Security and his/her Deputy and mostly guard sensitive areas, protect people, patrol, and handle other threats to the Federation.",
		'pos_dept' => 4,
		'pos_order' => 10,
		'pos_open' => 3,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Tactical Officer',
		'pos_desc' => "The Tactical Officers are the vessels gunmen. They assist the Chief Tactical Officer by running and maintaining the numerous weapons systems aboard the ship/starbase, and analysis and tactical planning of current missions. Very often Tactical Officers are also trained in ground combat and small unit tactics.",
		'pos_dept' => 4,
		'pos_order' => 15,
		'pos_open' => 3,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Security Investigations Officer',
		'pos_desc' => "The Security Investigations Officer is an Enlisted Officer. S/He fulfills the role of a special investigator or detective when dealing with Starfleet matters aboard ship or on a planet. Coordinates with the Chief Security Officer on all investigations as needed. The Security Investigations Officer reports to the Chief of Security.",
		'pos_dept' => 4,
		'pos_order' => 20,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Brig Officer',
		'pos_desc' => "The Brig Officer is a Security Officer who has chosen to specialize in a specific role. S/he guards the brig and its cells. But there are other duties associated with this post as well. S/he is responsible for any prisoner transport, and the questioning of prisoners. Often Brig Officers have a good knowledge of forcefield technology, and are experts in escaping such confinements.",
		'pos_dept' => 4,
		'pos_order' => 25,
		'pos_open' => 3,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Master-at-Arms',
		'pos_desc' => "The Master-at-Arms trains and supervises Security crewmen in departmental operations, repairs, and protocols; maintains duty assignments for all Security personnel; supervises weapons locker access and firearm deployment; and is qualified to temporarily act as Chief of Security if so ordered. The Master-at-Arms reports to the Chief of Security.",
		'pos_dept' => 4,
		'pos_order' => 30,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
		
	array(
		'pos_name' => 'Chief Operations Officer',
		'pos_desc' => "The Chief Operations Officer has the primary responsibility of ensuring that ship functions, such as the use of the lateral sensor array, do not interfere with one and another. S/he must prioritize resource allocations, so that the most critical activities can have every chance of success. If so required, s/he can curtail shipboard functions if s/he thinks they will interfere with the ship's current mission or routine operations.\r\n\r\nThe Chief Operations Officer oversees the Operations department, and is a member of the senior staff.",
		'pos_dept' => 5,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Assistant Chief Operations Officer',
		'pos_desc' => "The Chief Operations Officer cannot man the bridge at all times. Extra personnel are needed to relive and maintain ship operations. The Operations Officers are thus assistants to the Chief, fulfilling his/her duties when required, and assuming the Operations consoles if required at any time.\r\n\r\nThe Assistant Chief Operations Officer is the second-in-command of the Operations Department, and can assume the role of Chief Operations Officer on a temporary or permanent basis if so needed.",
		'pos_dept' => 5,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Operations Officer',
		'pos_desc' => "The Chief Operations Officer cannot man the bridge at all times. Extra personnel are needed to relive and maintain ship operations. The Operations Officers are thus assistants to the Chief, fulfilling his/her duties when required, and assuming the Operations consoles if required at any time.\r\n\r\nThe Operations Officer reports to the Chief Operations Officer.",
		'pos_dept' => 5,
		'pos_order' => 5,
		'pos_open' => 3,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Quartermaster',
		'pos_desc' => "The Quartermaster specializes in distributing supplies and provisions to personnel aboard the vessel. In addition, the Quartermaster controls all physical assignments to quarters throughout the vessel.",
		'pos_dept' => 5,
		'pos_order' => 6,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Boatswain',
		'pos_desc' => "Each vessel and base has one Warrant Officer (or Chief Warrant Officer) who holds the position of Boatswain. The Boatswain (pronounced and also written \"Bosun\" or \"Bos'n\") trains and supervises personnel (including both the ship's company or base personnel as well as passengers or vessels) in general ship and base operations, repairs, and protocols; maintains duty assignments for all Operations personnel; sets the agenda for instruction in general ship and base operations; supervises auxiliary and utility service personnel and daily ship or base maintenance; coordinates all personnel cross-trained in damage control operations and supervises damage control and emergency operations; may assume any Bridge or Operations role as required; and is qualified to temporarily act at Operations if so ordered.\r\n\r\nThe Boatswain reports to the Chief Operations Officer.",
		'pos_dept' => 5,
		'pos_order' => 10,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Transporter Specialist',
		'pos_desc' => "The Transporter Chief is responsible for all transports to and from other ships and any planetary bodies. When transporting is not going on, the Transporter Chief is responsible for keeping the transporters running at peak efficiency.\r\n\r\nThe team assigned to the Transporter Chief is made up from NCO personnel, assigned by the Assistant and Chief Engineer. The Transporter Chief reports to the Assistant and Chief Engineer.",
		'pos_dept' => 5,
		'pos_order' => 11,
		'pos_open' => 3,
		'pos_type' => 'enlisted'),
		
	array(
		'pos_name' => 'Chief Engineering Officer',
		'pos_desc' => "The Chief Engineer is responsible for the condition of all systems and equipment on board a Starfleet ship or facility. S/he oversees maintenance, repairs and upgrades of all equipment. S/he is also responsible for the many repair teams during crisis situations.\r\n\r\nThe Chief Engineer is not only the department head but also a senior officer, responsible for all the crew members in her/his department and maintenance of the duty rosters.",
		'pos_dept' => 6,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Assistant Chief Engineering Officer',
		'pos_desc' => "The Assistant Chief Engineer assists the Chief Engineer in the daily work; in issues regarding mechanical, administrative matters and coordinating repairs with other departments.\r\n\r\nIf so required, the Assistant Chief Engineer must be able to take over as Chief Engineer, and thus must be versed in current information regarding the ship or facility.",
		'pos_dept' => 6,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Engineering Officer',
		'pos_desc' => "Engineers are the backbone of the Engineering Corps and are responsible for, under the guidance of the Chief Engineer, maintaining and repairing the vessel.",
		'pos_dept' => 6,
		'pos_order' => 2,
		'pos_open' => 5,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Communications Specialist',
		'pos_desc' => "The Communications Specialist is a specialized engineer. Communication aboard a ship or facility takes two basic forms, voice and data. Both are handled by the onboard computer system and dedicated hardware. The vastness and complexity of this system requires a dedicated team to maintain the system.\r\n\r\nThe Communications Specialist is the officer in charge of this team, which is made up from NCO personnel, assigned to the team by the Assistant and Chief Engineer. The Communications Specialist reports to the Asst. and Chief Engineer.",
		'pos_dept' => 6,
		'pos_order' => 5,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Computer Systems Specialist',
		'pos_desc' => "The Computer Systems Specialist is a specialized Engineer. The new generation of Computer systems are highly developed. This system needs much maintenance and the Computer Systems Specialist was introduced to relieve the Science Officer, whose duty this was in the very early days.\r\n\r\nA small team is assigned to the Computer Systems Specialist, which is made up from NCO personnel assigned by the Assistant and Chief Engineer. The Computer Systems Specialist reports to the Assistant and Chief Engineer.",
		'pos_dept' => 6,
		'pos_order' => 6,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Damage Control Specialist',
		'pos_desc' => "The Damage Control Specialist is a specialized Engineer. The Damage Control Specialist controls all damage control aboard the ship when it gets damaged in battle. S/he oversees all damage repair aboard the ship, and coordinates repair teams on the smaller jobs so the Chief Engineer can worry about other matters.\r\n\r\nA small team is assigned to the Damage Control Specialist which is made up from NCO personnel assigned by the Assistant and Chief Engineer. The Damage Control Specialist reports to the Assistant and Chief Engineer.",
		'pos_dept' => 6,
		'pos_order' => 7,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Matter/Energy Systems Specialist',
		'pos_desc' => "The Matter / Energy Systems Specialist is a specialized Engineer. All aspect of matter energy transfers with the sole exception of the warp drive systems are handled by the Matter/Energy Systems Specialist. Such areas involved are transporter and replicator systems. The Matter/Energy Systems Specialist is the Officer in charge of a small team, which is made up from NCO personnel, assigned by the Assistant and Chief Engineer. The Matter/Energy Systems Specialist reports to the Assistant and Chief Engineer.",
		'pos_dept' => 6,
		'pos_order' => 8,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Propulsion Specialist',
		'pos_desc' => "Specializing in impulse and warp propulsion, these specialists are often specific to even a single class of ship due to the complexity of warp and impulse systems.",
		'pos_dept' => 6,
		'pos_order' => 9,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Structural/Environmental Specialist',
		'pos_desc' => "The Structural and Environmental Systems Specialist is a specialized Engineer. From a small ship/facility to a large one, all requires constant monitoring. The hull, bulkheads, walls, Jeffrey's tubes, turbolifts, structural integrity field, internal dampening field, and environmental systems are all monitored and maintained by this officer and his/her team.\r\n\r\nThe team assigned to the Structural and Environmental Systems Specialist is made up from NCO personnel, assigned by the Assistant and Chief Engineer. The Structural and Environmental Systems Specialist reports to the Asst and Chief Engineer.",
		'pos_dept' => 6,
		'pos_order' => 10,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
		
	array(
		'pos_name' => 'Chief Science Officer',
		'pos_desc' => "The Chief Science Officer is responsible for all the scientific data the ship/facility collects, and the distribution of such data to specific section within the department for analysis. S/he is also responsible with providing the ship's captain with scientific information needed for command decisions.\r\n\r\nS/he also is a department head and a member of the Senior Staff and responsible for all the crew members in her/his department and duty rosters.",
		'pos_dept' => 7,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Assistant Chief Science Officer',
		'pos_desc' => "The Assistant Chief Science Officer assists Chief Science Officer in all areas, such as administration, and analysis of scientific data. The Assistant often take part in specific analysis of important data along with the Chief Science Officer, however spends most time overseeing current project and their section heads.",
		'pos_dept' => 7,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Science Officer',
		'pos_desc' => "There are several general Science Officers aboard each vessel. They are assigned to their duties by the Chief Science Officer and his Assistant. Assignments include work for the Specialized Section heads, as well as duties for work being carried out by the Chief and Assistant.",
		'pos_dept' => 7,
		'pos_order' => 2,
		'pos_open' => 3,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Astrometrics Officer',
		'pos_desc' => "Specialized Science Officer in charge of the Astrometrics Section. This role entails the maintaining, correction and production of new stellar maps. Has close ties with the the Physicist and Stellar Cartographers.",
		'pos_dept' => 7,
		'pos_order' => 3,
		'pos_open' => 2,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Alien Archaeologist/Anthropologist',
		'pos_desc' => "Specialized Science Officer in charge of the Alien Culture Section. This role involves the study of all newly discovered alien species and life forms, from the long dead to thriving. Their knowledge also involves current known alien species. Has close ties to the Historian.\r\n\r\nAnswers to the Chief Science Officer and Assistant Chief Science Officer.",
		'pos_dept' => 7,
		'pos_order' => 5,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Biologist',
		'pos_desc' => "Specialized Science Officer in charge of the Biology Section. This role entails the study of biology, botany, zoology and many more Life Sciences. On larger ships there many be a number of Science Officers within this section, under the lead of the Biologist.",
		'pos_dept' => 7,
		'pos_order' => 6,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Language Specialist',
		'pos_desc' => "Specialized Communications Officer in charge of the Linguistics section. This role involves the study of new and old languages and text in an attempt to better understand and interpret their meaning.\r\n\r\nAnswers to the Chief and Assistant Chief Communications Officer (if present) or the Chief and Assistant Chief Science Officer.",
		'pos_dept' => 7,
		'pos_order' => 7,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Stellar Cartographer',
		'pos_desc' => "Specialized Science Officer in charge of the Stellar Cartography bay. This role entails the mapping of all spatial phenomenon, and the implications of such phenomenon. Has close ties with the Physicist and Astrometrics Officer.",
		'pos_dept' => 7,
		'pos_order' => 8,
		'pos_open' => 1,
		'pos_type' => 'officer'),
		
	array(
		'pos_name' => 'Chief Medical Officer',
		'pos_desc' => "The Chief Medical Officer is responsible for the physical health of the entire crew, but does more than patch up injured crew members. His/her function is to ensure that they do not get sick or injured to begin with, and to this end monitors their health and conditioning with regular check ups. If necessary, the Chief Medical Officer can remove anyone from duty, even a Commanding Officer. Besides this s/he is available to provide medical advice to any individual who requests it.\r\n\r\nAdditionally the Chief is also responsible for all aspect of the medical deck, such as the Medical labs, Surgical suites and Dentistry labs.\r\n\r\nS/he also is a department head and a member of the Senior Staff and responsible for all the crew members in her/his department and duty rosters.",
		'pos_dept' => 8,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Chief Counselor',
		'pos_desc' => "Because of their training in psychology, technically the ship's/facility's Counselor is considered part of Starfleet medical. The Counselor is responsible both for advising the Commanding Officer in dealing with other people and races, and in helping crew members with personal, psychological, and emotional problems.\r\n\r\nThe Chief Counselor is considered a member of the Senior Staff. S/he is responsible for the crew in his/her department. The Chief Counselor is the Counselor with the highest rank and most experience.",
		'pos_dept' => 8,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Assistant Chief Medical Officer',
		'pos_desc' => "A starship or facility has numerous personnel aboard, and thus the Chief Medical Officer cannot be expect to do all the work required. The Asst. Chief Medical Officer assists Chief in all areas, such as administration, and application of medical care.",
		'pos_dept' => 8,
		'pos_order' => 2,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Medical Officer',
		'pos_desc' => "Medical Officer undertake the majority of the work aboard the ship/facility, examining the crew, and administering medical care under the instruction of the Chief Medical Officer and Assistant Chief Medical Officer also run the other Medical areas not directly overseen by the Chief Medical Officer.",
		'pos_dept' => 8,
		'pos_order' => 3,
		'pos_open' => 3,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Surgeon',
		'pos_desc' => "Doctors of the federation still specialize and mostly, the Chief Medical Officer position is usually held by a general practitioner. While simple surgery is part of their training, some doctors on larger vessels and starbases prefer to have a surgeon on staff.",
		'pos_dept' => 8,
		'pos_order' => 4,
		'pos_open' => 3,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Counselor',
		'pos_desc' => "Because of their training in psychology, technically the ship's/facility's Counselor is considered part of Starfleet medical. The Counselor is responsible both for advising the Commanding Officer in dealing with other people and races, and in helping crew members with personal, psychological, and emotional problems.",
		'pos_dept' => 8,
		'pos_order' => 5,
		'pos_open' => 2,
		'pos_type' => 'officer'),
	array(
		'pos_name' => "Counselor's Aide",
		'pos_desc' => "The Counselor's Aide helps keep all the matters of the Counseling Department in order. S/he assigns appointments for anyone needing them, and assists the Counselors with anything that they may need.",
		'pos_dept' => 8,
		'pos_order' => 6,
		'pos_open' => 2,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Head Nurse',
		'pos_desc' => "The Head Nurse oversees all the Nurses currently aboard, ensuring they are assigned to tasks and working as required in their area. Additionally the Head nurse performs the normal duties of the nurse, assisting the Duty Medical Officer in sickbay.",
		'pos_dept' => 8,
		'pos_order' => 7,
		'pos_open' => 3,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Nurse',
		'pos_desc' => "Nurses are trained in basic medical care, and are capable of dealing with less serious medical cases. In more serious matters the nurse assists the medical officer in the examination and administration of medical care, be this injecting required drugs, or simply assuring the injured party that they will be ok. The Nurses also maintain the medical wards, overseeing the patients and ensuring they are receiving medication and care as instructed by the Medical Officer.",
		'pos_dept' => 8,
		'pos_order' => 8,
		'pos_open' => 3,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Morale Officer',
		'pos_desc' => "Responsible for keeping the morale of the crew high. Delivers regular reports on morale to the Executive Officer. The Morale Officer plans activities that will keep the crew's morale and demeanor up. If any crew member is having problems, the Morale Officer can assist that crew member.",
		'pos_dept' => 8,
		'pos_order' => 9,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	
	array(
		'pos_name' => 'Chief Intelligence Officer',
		'pos_desc' => "Responsible for managing the intelligence department in its various facets, the Chief Intelligence officer often assists the Strategic Operations officer with information gathering and analysis, and then acts as a channel of information to the CO and bridge crew during combat situations.",
		'pos_dept' => 9,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Assistant Chief Intelligence Officer',
		'pos_desc' => "Responsible for aiding the Chief Intelligence Officer in managing the intelligence department in its various facets, often assisting the Strategic Operations officer with information gathering and analysis.",
		'pos_dept' => 9,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Intelligence Officer',
		'pos_desc' => "Responsible for gathering intelligence, an Intelligence officer has the patience to read through a database for hours on end, and the cunning to coax information from an unwilling giver. S/he must provide this information to the Chief Intelligence officer as it becomes needed.",
		'pos_dept' => 9,
		'pos_order' => 2,
		'pos_open' => 2,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Infiltration Specialist',
		'pos_desc' => "The Infiltration Specialist is trained the arts of covert operations and infiltration. They are trained to get into and out of enemy instillations, territory, etc. Once in, they can gather intel, or if needed plant explosives, and even in times of war capture of enemy personnel. The Infiltration Specialist reports to the Chief Intelligence Officer.",
		'pos_dept' => 9,
		'pos_order' => 3,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Encryption Specialist',
		'pos_desc' => "This NCO takes submitted Intelligence reports and runs them through algorithms, checking for keywords that denote mistyped classification and then puts the report into crypto form and sends them through the proper channels of communication to either on board ship consoles or off board to who ever needs to receive it. The Encryption Specialist reports to the Chief Intelligence Officer.",
		'pos_dept' => 9,
		'pos_order' => 4,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	
	array(
		'pos_name' => 'Chief Diplomatic Officer',
		'pos_desc' => "The Diplomatic Officer of each vessel/base must be familiar with a variety of areas: history, religion, politics, economics, and military, and understand how they affect potential threats. A wide range of operations can occur in response to these areas and threats. These operations occur within three general states of being: peacetime competition, conflict and war.\r\n\r\nS/he must be equally flexible and demonstrate initiative, agility, depth, synchronization, and improvisation to provide responsive legal services to his/her Commanding Officer as well a diplomatic advise on current status of an Alien Species both aligned and non aligned to the Federation.\r\n\r\nThe Chief Diplomatic Officer is in charge of the Diplomatic Corps Detachment. He or she oversees the operation of it, as well as makes sure everything in that department is carried out according to Starfleet Regulations.",
		'pos_dept' => 10,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Assistant Chief Diplomatic Officer',
		'pos_desc' => "The Diplomatic Officer of each vessel/base must be familiar with a variety of areas: history, religion, politics, economics, and military, and understand how they affect potential threats. A wide range of operations can occur in response to these areas and threats. These operations occur within three general states of being: peacetime competition, conflict and war.\r\n\r\nS/he must be equally flexible and demonstrate initiative, agility, depth, synchronization, and improvisation to provide responsive legal services to his/her Commanding Officer aiding in official functions as prescribed by protocol, performing administrative duties, and other tasks as directed by the Chief Diplomatic Officer, as well a diplomatic advise on current status of an Alien Species both aligned and non aligned to the Federation.\r\n\r\nThe Assistant Chief Diplomatic Officer is the second-in-command of the Diplomatic Corps Detachment. If necessary, he or she can take the place of the Chief Diplomatic Officer on a temporary or permanent basis.",
		'pos_dept' => 10,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Diplomatic Officer',
		'pos_desc' => "The Diplomatic Officer of each vessel/base must be familiar with a variety of areas: history, religion, politics, economics, and military, and understand how they affect potential threats. A wide range of operations can occur in response to these areas and threats. These operations occur within three general states of being: peacetime competition, conflict and war.\r\n\r\nS/he must be equally flexible and demonstrate initiative, agility, depth, synchronization, and improvisation to provide responsive legal services to his/her Commanding Officer aiding in official functions as prescribed by protocol, performing administrative duties, and other tasks as directed by the Chief Diplomatic Officer and/or Assistant Chief Diplomatic Officer as well a diplomatic advice on current status of an Alien Species both aligned and non aligned to the Federation.",
		'pos_dept' => 10,
		'pos_order' => 2,
		'pos_open' => 2,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Diplomatic Corpsman',
		'pos_desc' => "The Diplomatic Corpsman is a special position reserved for enlisted officers who wish to study diplomacy, and aid the department in its mission. Their duties consist of, but are not limited to, aiding Diplomatic Officers and Diplomat's Aide in the construction of various legal documents, researching diplomatic archives, attending and aiding in the preparation for diplomatic functions, and other tasks as prescribed by the Chief Diplomatic Officer and/or Assistant Chief Diplomatic Officer. These individuals are qualified to undertake some of the responsibilities of a Diplomatic Officer, as their training are far less in-depth. They are, however, able to, and adequately trained to function as a paralegal when such services are required by a vessel/base's crew.",
		'pos_dept' => 10,
		'pos_order' => 3,
		'pos_open' => 2,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => "Diplomat's Aide",
		'pos_desc' => "S/he responds to the Ship/Base's Chief Diplomatic Officer, and is required to be able to stand in and run the Diplomatic Department as required should the Chief Diplomatic Officer be absent for any reason.\r\n\r\nThe Aide must therefore be versed in all Diplomatic information regarding the current status of the Federation and its aligned and non aligned neighbours.",
		'pos_dept' => 10,
		'pos_order' => 4,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Media Relations Officer',
		'pos_desc' => "Like it or not, the public has a right to know what Starfleet is up to. To get the word out to journalists or in the case of classified missions, to keep word from getting out. The Chief Diplomatic Officer will usually appoint one of their Diplomatic Officers to serve as the Media Relations Officer.\r\n\r\nWith the exceptions of large stations and/or high profile diplomatic negotiations the Media Relations Officer duties consist of, but are not limited to keeping the Chief Diplomatic Officer and Assistant Chief Diplomatic Officer informed of all relevant media stories, dealing with the press on a daily basis, creating and issuing mission statments, conducting personal interviews, and answer questions from the media journalists.",
		'pos_dept' => 10,
		'pos_order' => 5,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Translation Specialist',
		'pos_desc' => "The Translation Specialist is a person capable of translating written and spoken languages in real-time. They often have roles of interpreters and mediators due to their extensive linguistic capabilities. Translation Specialist reports to the Language Specialist.\r\n\r\nAlthough s/he is considered a Communications Officer the position also has close ties to the diplomacy. Under diplomacy the Translation Specialist is charged with the translation of any language, living or dead, that may be encountered by a vessel/base that the Universal Translator system can not interpret. These individuals are adept at using various decryption techniques to aid in the deciphering of such languages. These individuals are qualified to undertake any tasks that could be asked of a general Diplomatic Officer; however they specialize in the linguistic aspect of this department.",
		'pos_dept' => 10,
		'pos_order' => 6,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
		
	array(
		'pos_name' => 'Marine Commanding Officer',
		'pos_desc' => "The Marine CO is responsible for all the Marine personnel assigned to the ship/facility. S/he is in required to take command of any special ground operations and lease such actions with security. The Marines could be called the 24th century commandos.\r\n\r\nThe CO can range from a Second Lieutenant on a small ship to a Lieutenant Colonel on a large facility or colony. Charged with the training, condition and tactical leadership of the Marine compliment, they are a member of the senior staff.\r\n\r\nAnswers to the Commanding Officer of the ship/facility.",
		'pos_dept' => 11,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Marine Executive Officer',
		'pos_desc' => "The Executive Officer of the Marines, works like any Asst. Department head, removing some of the work load from the Marine CO and if the need arises taking on the role of Marine CO. S/he oversees the regular duties of the Marines, from regular drills to equipment training, assignment and supply request to the ship/facilities Materials Officer.\r\n\r\nAnswers to the Marine Commanding Officer.",
		'pos_dept' => 11,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'First Sergeant',
		'pos_desc' => "The First Sergeant is the highest ranked Enlisted marine. S/He is in charge of all of the marine enlisted affairs in the detachment. They assist the Company or Detachment Commander as their Executive Officer would. They act as a bridge, closing the gap between the NCO\'s and the Officers.\r\n\r\nAnswers To Marine Commanding Officer.",
		'pos_dept' => 11,
		'pos_order' => 2,
		'pos_open' => 1,
		'pos_type' => 'enlisted'),
	array(
		'pos_name' => 'Marine',
		'pos_desc' => "Serving within a squad, the marine is trained in a variety of means of combat, from melee to ranged projectile to sniping.",
		'pos_dept' => 11,
		'pos_order' => 3,
		'pos_open' => 5,
		'pos_type' => 'enlisted'),
		
	array(
		'pos_name' => 'Group Commander',
		'pos_desc' => "The Group Commander is in charge of all things related to his group's fighters, generally a responsibility of over 96 starfighters. As well, the group commander is responsible for all the personnel assigned to the group on the ship/facility, and ensuring that maintenance work is carried on the craft by Engineering.\r\n\r\nThe Group Commander reports to the Commanding Officer or Executive Officer and is a member of the Senior Staff.",
		'pos_dept' => 12,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Wing Commander',
		'pos_desc' => "The Wing Commander is in charge of all things related to his wing's fighters, generally a responsibility of between 48 and 72 starfighters. As well, the wing commander is responsible for all the personnel assigned to the flight on the ship/facility, and ensuring that maintenance work is carried on the craft by Engineering.\r\n\r\nReports to the Group Commander. If the Wing Commander is the senior starfighter pilot assigned to the starship, starbase or facility they report to the Commanding Officer or Executive Officer and is a member of the Senior Staff.",
		'pos_dept' => 12,
		'pos_order' => 1,
		'pos_open' => 1,
		'pos_type' => 'senior'),
	array(
		'pos_name' => 'Squadron Leader',
		'pos_desc' => "The Squadron Leader is in charge of all things related to his squadron's fighters, generally a responsibility of up to 24 starfighters. As well, the squadron leader is responsible for all the personnel assigned to the squadron on the ship/facility, and ensuring that maintenance work is carried on the craft by Engineering.\r\n\r\nReports to the Wing Commander. If the Squadron Leader is the senior starfighter pilot assigned to the starship, starbase or facility they report to the Commanding Officer or Executive Officer and is a member of the Senior Staff.",
		'pos_dept' => 12,
		'pos_order' => 2,
		'pos_open' => 2,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Flight Leader',
		'pos_desc' => "The Flight Leader is in charge of all things related to his flight's fighters, generally a responsibility of up to 8 starfighters. As well, the flight leader is responsible for all the personnel assigned to the flight on the ship/facility, and ensuring that maintenance work is carried on the craft by Engineering.\r\n\r\nReports to the Squadron Leader. If the Flight Leader is the senior starfighter pilot assigned to the starship, starbase or facility they report to the Commanding Officer or Executive Officer and is a member of the Senior Staff.",
		'pos_dept' => 12,
		'pos_order' => 3,
		'pos_open' => 2,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Fighter Pilot',
		'pos_desc' => "Specialized pilot, trained in all areas and aspects of fighter combat. They are also familiar with runabouts, shuttles and transports.\r\n\r\nTo be a fighter pilot the pilot must hold a rank from within the Warrant Officer Ranks or commissioned ranks.\r\n\r\nReports to the Flight Leader.",
		'pos_dept' => 12,
		'pos_order' => 4,
		'pos_open' => 4,
		'pos_type' => 'officer'),
	array(
		'pos_name' => 'Tactical Systems Operator',
		'pos_desc' => "The Tactical Systems Operator (or TSO) is responsible for operating all offensive and defensive systems in fighters which have two operators. This frees the pilot to handle only the operation of the aerospacecraft. Most TSOs are also trained as pilots, for circumstances when the main pilot of the fighter is incapacitated or killed but the craft is still servicable. The TSO answers to the Flight Leader, and is generally subordinate to the Fighter Pilot operating his/her craft.\r\n\r\nBecause of the location of the TSO's seat in most fighters, the position is sometimes known as the 'back seater'.",
		'pos_dept' => 12,
		'pos_order' => 5,
		'pos_open' => 4,
		'pos_type' => 'officer'),
		
	array(
		'pos_name' => 'Chef',
		'pos_desc' => "Responsible for preparing all meals served in the Mess Hall and for the food during any diplomatic functions that may be held onboard.",
		'pos_dept' => 13,
		'pos_order' => 0,
		'pos_open' => 1,
		'pos_type' => 'enlisted')
);

$catalogue_ranks = array(
	array(
		'rankcat_name' => 'Duty Uniform',
		'rankcat_location' => 'default',
		'rankcat_credits' => "The rank sets used in Nova were created by Kuro-chan of Kuro-RPG. The ranksets can be found at <a href='http://www.kuro-rpg.net' target='_blank''>Kuro-RPG</a>. Please do not copy or modify the images.",
		'rankcat_default' => 'y',
		'rankcat_url' => 'http://www.kuro-rpg.net/',
		'rankcat_genre' => $g),
);
