<?php
//-----------------------------------------------------------------------------
//                        UPLOADING DEMO, VERSION 1.3
//                     Created by: Kuro-chan (2015-2019)
//-----------------------------------------------------------------------------
//
//
// Version 1.3
// - Version number is now displayed on the main page, making it easier to
//   identify if the uploader is up-to-date.
// - Attached an editor so text files can be edited.
// - Fixed a problem with a character not showing up on newer browsers.
// - Added additional login features; the ability to restrict file editing
//   and deleting files by certain users.
// - Added 1 entries to the css page:
//     -- textarea, near the top
// - Made 1 change to the css page to fix an alignment issue with the new
//   File Uploader box
//     -- changed the border with in .form from 2px to 1 px.
//
// (Filesize suggestions provided by: Azmaria)
//
// Version 1.2
// - File size is now included.
// - Includes an alternative MIME reader, in case system() produces an error
//   log.
// - Updated a couple of the image buttons.
//
// (Suggestions provided by: Azmaria)
//
// Version 1.1
// - Multiple accounts are now permitted.
// - Sub-folders can be created and removed. Files can be uploaded and
//   removed from the sub-folders.
// - Sub-folders can be (somewhat) navigated through the uploader.
//
// (Suggestions provided by: Stephen Clark)
//
// Version 1.0
// - Basic program is completed.
//
//
//-----------------------------------------------------------------------------
// Details for login

// - Input a Username a Password in the quotes below.  If you use quotes within
//   the quotes, it is important to add a backslash (\) in front of it,
//   otherwise it corrupts the variable.
// Example:
// Mr. "Fancy"  ->  Mr. \"Fancy\"
// - Multiple logins are now supported. You can have as many as you want. To
//   use them, attach a [number] to the end of a login set. There should be no
//   gaps in the numbers and ALWAYS start with zero.  If you only use one
//   login, please still use a [0].
//
// Example:
// $login_username[0]="demo";
// $login_username[1]="evil";
// $login_username[2]="mayhem";
//
// -- Variable details:
// $username: For identification.  It shows up along the top bar.
// $login_username: Your login username.
// $login_password: Your login password.
// $directory_name: Where are the files are being uploaded. This is the user's
//                  root directory and is helpful for controlling where they
//                  are allowed to upload.
// $allow_delete:   This gives a user permission to delete files/directories.
//                  Set to "no" or "yes".
// $allow_edit:     This gives a user permission to edit text files.
//                  Set to "no" or "yes".
//
//

// Who this belongs to (Make it a SUPER cool name)
$username="Hera";

// Username & Password
// #0 (ALWAYS start with Zero)7
$login_username[0]="admin";
$login_password[0]="temp1234";
$directory_root[0]="uploads";
$allow_delete[0]="yes";
$allow_edit[0]="yes";


//
//
//-----------------------------------------------------------------------------
// Additional Variables
//
// The command system() is used by this engine to pull the MIME info (what the
// file type is) to create a small icon image.  However, with some PHP
// versions, system() is disabled.  If set to 0, an alternate, though less
// detailed setup is used get the info for the icons.
//
// 0 - Do not use system()
// 1 - Use system()

$use_system=0;

//-----------------------------------------------------------------------------
//---
//-----------------------------------------------------------------------------
// Leave everything below alone. This is the code required to run the script!

// Check for Login and Cookies first before doing anything else.  You may
// change the random garble in $allow_script, if you wish, but it must also be
// changed in files.php and login.php (1st line in both)
$allow_script="58fjn387j09feh48";
$files_host="no";
$delete_files="no";
$edit_files="no";
session_start(); 

for($x=0; $x!=count($login_username); $x++)
if ($_SESSION[($login_username[$x].'_online')])
{
	$files_host="yes";
	$display_name=$login_username[$x];
	$directory_name=$directory_root[$x];
	$delete_files=$allow_delete[$x];
	$edit_files=$allow_edit[$x];
}

//Function for exiting a file/folder handler
function check_exit($x_result)
{
	if(empty($x_result))
	{header("location: ./index.php");}
	else
	{header("location: ./?folder=".$x_result);}
}

//Checks login data submitted
if ($_POST['host_username']) {
	$result_host_username=$_POST['host_username'];
	$result_host_password=$_POST['host_password'];
	include './scripts/login_include.php';
}

//Checks for pre-established cookies
if (($files_host=="no")&&(isset($_COOKIE["host_username"]))&&(isset($_COOKIE["host_secretword"]))) {
	$result_host_username=$_COOKIE['host_username'];
	$result_host_password=$_COOKIE['host_secretword'];
	include './scripts/login_include.php';
}

//Check for logout
if ($_POST['logout']) {
	session_destroy();
	$set_expire=time()-60*60*24*30;
	setcookie('host_username', '', $set_expire); 
	setcookie('host_secretword', '', $set_expire); 
	$files_host="no";
}

//Check for content to be submitted
if ($_POST['submit_file']) {
	$convert_file=array('\''=>'_', ' '=>'_', ';'=>'_', '\"'=>'"', '<?php'=>'_');
	$file=$_FILES['inputFile'];
	$file_name=strtr($file['name'],$convert_file);
	$temp_directory="./".$_POST['upload_folder']."/".$file_name;
	move_uploaded_file($_FILES['inputFile']["tmp_name"],$temp_directory);
	check_exit($_POST['return']);
}

//Edit a text file.
if ($_POST['submit_edit']) {
	$edit_name=$_POST['edit_file'];
	$myfile = fopen($edit_name, "w") or die("Unable to open file!");
	$txt = $_POST['text_content'];
	fwrite($myfile, $txt);
	fclose($myfile);
}

//Check for an entry to delete
if ($_POST['submit_delete']) {
	$delete_name="./".$_POST['upload_folder']."/".$_POST['delete_file'];
	unlink($delete_name);
	check_exit($_POST['return']);
}

//Check for Folder creation
if ($_POST['create_folder']) {
	if(!empty($_POST['new_folder']))
	{
		$convert_file=array('\''=>'',';'=>'',':'=>'','?'=>'','\"'=>'"','&'=>'','|'=>'','<'=>'','>'=>'');
		$dir_name=strtr($_POST['new_folder'],$convert_file);
		$test_folder=$_POST['new_src'].'/'.$dir_name;
		if (file_exists($test_folder))
		{}
		else
		{mkdir($test_folder, 0777, true);}
	}
	check_exit($_POST['return']);
}

//Check for Folder deletion
if ($_POST['remove_folder']) {
	if (file_exists($_POST['delete_folder']))
	{rmdir($_POST['delete_folder']);}
	check_exit($_POST['return']);
}

//remove the "//" if you want to see what your upload max. is
//echo ini_get('upload_max_filesize');

// Start Basic Page
echo '<head><meta charset="UTF-8"><link href="style.css" rel="stylesheet" type="text/css"><title>',$username,'\'s Sim Backup Service</title></head><body>';
?>





<script>
function $D(a){return document.getElementById(a);}
</script>
<?php
if ($files_host=="yes"){
	if ($_POST['new_edit']) {include './scripts/editor.php';}
	else {include './scripts/files.php';}
}
else {include './scripts/login.php';}
?>
</body>
