<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once MODPATH.'core/controllers/nova_main.php';

class Main extends Nova_main {
	
	public function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * Put your own methods below this...
	 */

public function chat()
{
	$data['header'] = "Alliance IRC";

	$this->_regions['content'] = Location::view('chat', $this->skin, 'main', $data);
	$this->_regions['title'].= $data['header'];
	
	Template::assign($this->_regions);
	
	Template::render();
}

	public function contact()
	{
		// load the validation library
		$this->load->library('form_validation');
		
		// make sure the error messages are using the proper syntax
		$this->form_validation->set_error_delimiters('<span class="red bold error-icon">', '</span><br />');
		
		// set the validation rules
		$this->form_validation->set_rules('name', 'lang:labels_name', 'required');
		$this->form_validation->set_rules('email', 'lang:labels_email_address', 'required|valid_email');
		$this->form_validation->set_rules('subject', 'lang:labels_subject', 'required');
		$this->form_validation->set_rules('message', 'lang:labels_message', 'required');
		
		if (isset($_POST['submit']))
		{
			$array = array(
				'name'		=> $this->input->post('name'),
				'email'		=> $this->input->post('email'),
				'subject'	=> $this->input->post('subject'),
				'message'	=> $this->input->post('message')
			);
			
			//Check is always false
			$check = false;
			//Secret key for recaptcha
			$secret = "6Lf7SggTAAAAAD_GAFgImxXJJEBbPNx-CriLwzAV";
			$captcha_errors;
			
			
			//If there is any recaptcha ... 
			if(isset($_POST['g-recaptcha-response']))
			{
				require_once('autoload.php');
				//Initialize
				$recaptcha = new \ReCaptcha\ReCaptcha($secret);
				//Verify with google
				$resp = $recaptcha->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);
				//get the return
				$check = $resp->isSuccess();
                		if(!$check) 
					$captcha_errors = $resp->getErrorCodes();
					     $flash['status'] = 'error';
					     $flash['message'] = text_output('Error - you need to complete the ReCaptcha.');
					     $this->_regions['flash_message'] = Location::view('flash', $this->skin, 'main', $flash); 
			}
			
			
			if ($this->form_validation->run() && $check)
			{
				$email = ($this->options['system_email'] == 'on') ? $this->_email('contact', $array) : false;
				
				if ( ! $email)
				{
					$message = sprintf(
						lang('flash_failure'),
						ucfirst(lang('labels_contact')),
						lang('actions_sent'),
						''
					);
					
					$flash['status'] = 'error';
					$flash['message'] = text_output($message);
				}
				else
				{
					$message = sprintf(
						lang('flash_success'),
						ucfirst(lang('labels_contact')),
						lang('actions_sent'),
						''
					);
					
					$flash['status'] = 'success';
					$flash['message'] = text_output($message);
				}
				
				$this->_regions['flash_message'] = Location::view('flash', $this->skin, 'main', $flash);
			}
		}
		
		// set the title, header and content variables
		$data['header'] = ucwords(lang('actions_contact').' '.lang('labels_us'));
		$data['msg'] = $this->msgs->get_message('contact');
		
		$data['button'] = array(
			'submit' => array(
				'type' => 'submit',
				'class' => 'button-main',
				'name' => 'submit',
				'value' => 'submit',
				'content' => ucwords(lang('actions_submit'))),
		);
		
		if ($this->options['system_email'] == 'off')
		{
			$data['button']['submit']['disabled'] = 'disabled';
		}
		
		$data['inputs'] = array(
			'name' => array(
				'name' => 'name',
				'id' => 'name',
				'value' => set_value('name')),
			'email' => array(
				'name' => 'email',
				'id' => 'email',
				'value' => set_value('email')),
			'subject' => array(
				'name' => 'subject',
				'id' => 'subject',
				'value' => set_value('subject')),
			'message' => array(
				'name' => 'message',
				'id' => 'message',
				'rows' => 12,
				'value' => set_value('message'))
		);
		
		$data['label'] = array(
			'send' => ucwords(lang('actions_send') .' '. lang('labels_to')),
			'name' => ucwords(lang('labels_name')),
			'email' => ucwords(lang('labels_email_address')),
			'subject' => ucwords(lang('labels_subject')),
			'message' => ucwords(lang('labels_message')),
			'nosubmit' => lang('flash_system_email_off_disabled'),
		);
		
		$this->_regions['content'] = Location::view('main_contact', $this->skin, 'main', $data);
		$this->_regions['title'].= $data['header'];
		
		Template::assign($this->_regions);
		
		Template::render();
	}

}

